class Match(object):
    def __init__(self, file_name, text, position, **kwargs):
        self.file_name = file_name
        self.text = text
        self.position = position
        self.kwargs = kwargs

    def __str__(self):
        kwargs_list = []
        for key in self.kwargs:
            kwargs_list.append(str(key) + ": " + str(self.kwargs[key]))
        kwargs_string = ""
        if kwargs_list:
            kwargs_string = ", Keyword Args: " + ", ".join(kwargs_list)

        return f"Match: {{File: {self.file_name}, Pos: {self.position}, Matched Text: {self.text}{kwargs_string}}}"

    def update_keyword_args(self, **kwargs):
        self.kwargs.update(kwargs)


def update_keyword_args_on_matches(matches_list, **kwargs):
    for match in matches_list:
        match.kwargs.update(kwargs)
